from typing import Literal
import examples.ags.w_action_node.optimized.DROP.graphs.template.operator as operator
import examples.ags.w_action_node.optimized.DROP.graphs.round_3.prompt as prompt_custom
from provider.llm_provider_registry import create_llm_instance
from utils.cost_manager import CostManager

DatasetType = Literal["HumanEval", "MMBP", "Gsm8K", "MATH", "HotpotQa", "MMLU"]

class SolveGraph:
    def __init__(
        self,
        name: str,
        llm_config,
        dataset: DatasetType,
    ) -> None:
        self.name = name
        self.dataset = dataset
        self.llm = create_llm_instance(llm_config)
        self.llm.cost_manager = CostManager()
        self.custom = operator.Custom(self.llm)
        self.answer_generate = operator.AnswerGenerate(self.llm)
        self.sc_ensemble = operator.ScEnsemble(self.llm)

    async def __call__(self, problem: str):
        """
        Implementation of the graph
        """
        solutions = []
        for _ in range(3):  # Generate 3 solutions
            step_by_step = await self.answer_generate(input=problem)
            solutions.append(step_by_step['answer'])
        
        ensemble_solution = await self.sc_ensemble(solutions=solutions)
        
        final_solution = await self.custom(input=f"Question: {problem}\nBest solution: {ensemble_solution['response']}", instruction=prompt_custom.REFINE_ANSWER_PROMPT)

        return final_solution['response'], self.llm.cost_manager.total_cost
                    